<?php if (!defined('ABSPATH')) exit; // Exit if accessed directly ?>

<?php do_action('wpo_wcpdf_before_document', $this->get_type(), $this->order); ?>

<table class="head container">
    <tr>
        <td class="header">
            <?php if ($this->has_header_logo()) : ?>
                <?php do_action('wpo_wcpdf_before_shop_logo', $this->get_type(), $this->order); ?>
                <?php $this->header_logo(); ?>
                <?php do_action('wpo_wcpdf_after_shop_logo', $this->get_type(), $this->order); ?>
                <br>
            <?php else : ?>
                <?php $this->title(); ?>
            <?php endif; ?>
        </td>
        <td class="shop-info">
            <!--            --><?php //do_action('wpo_wcpdf_before_shop_name', $this->get_type(), $this->order); ?>
            <!--            <div class="shop-name"><h3>--><?php //$this->shop_name(); ?><!--</h3></div>-->
            <!--            --><?php //do_action('wpo_wcpdf_after_shop_name', $this->get_type(), $this->order); ?>
            <!--            --><?php //do_action('wpo_wcpdf_before_shop_address', $this->get_type(), $this->order); ?>
            <!--            <div class="shop-address">--><?php //$this->shop_address(); ?><!--</div>-->
            <!--            --><?php //do_action('wpo_wcpdf_after_shop_address', $this->get_type(), $this->order); ?>
        </td>
    </tr>
</table>

<?php do_action('wpo_wcpdf_before_document_label', $this->get_type(), $this->order); ?>

<?php
$numar_caserole = 0;
foreach ($order->get_items() as $item) {
    $numar_caserole += $item->get_quantity();
}
//if ($numar_caserole > 0) {
//    $cutii = get_optimal_boxes_for_caserole($numar_caserole);
//    echo '<h3 style="font-size: 22px; font-weight: 600;">Verpackungs Typ:</h3>';
//    foreach ($cutii['combo'] as $tip => $cant) {
//        if ($cant > 0) echo "<b style='font-size: 18px; line-height: 1.2; display: block;'>$cant x $tip</b><br>";
//    }
//    echo "<p style='font-size: 18px; margin: 0 0 10px 0; line-height: 1.2; display: block;'>Aufläufe insgesamt: <strong style='font-size: 18px;'>$numar_caserole</strong><br> </p>";
//
//}
if ($numar_caserole > 0) {
    $cutii = get_optimal_boxes_for_caserole($numar_caserole);
    $combo = $cutii['combo'];

    // Capacitatea fiecărei cutii
    $capacities = [
        'B7/ 20l' => 7,
        'B14/ 39l' => 14,
        'B20/ 60l' => 20,
    ];

    // Cutiile folosite (> 0 bucăți)
    $cutii_folosite = array_filter($combo);

    // Găsim cutia cu capacitatea cea mai mică dintre cele folosite
    $cutia_minima = null;
    $capacitate_minima = PHP_INT_MAX;
    foreach ($cutii_folosite as $tip => $cant) {
        if (isset($capacities[$tip]) && $capacities[$tip] < $capacitate_minima) {
            $capacitate_minima = $capacities[$tip];
            $cutia_minima = $tip;
        }
    }

    echo '<h3 style="font-size: 22px; font-weight: 600;">Verpackungs Typ:</h3>';
    foreach ($combo as $tip => $cant) {
        if ($cant > 0) {
            $nota = '';
            if (count($cutii_folosite) > 1 && $tip === $cutia_minima) {
                $nota = ' <span style="font-size: 16px; color: #888;">(Immer voll)</span>';
            }
            echo "<b style='font-size: 18px; line-height: 1.2; display: block;'>$cant x $tip $nota</b><br>";
        }
    }

    echo "<p style='font-size: 18px; margin: 0 0 10px 0; line-height: 1.2; display: block;'>Aufläufe insgesamt: <strong style='font-size: 18px;'>$numar_caserole</strong><br> </p>";
}

?>

<?php if ($this->has_header_logo()) : ?>
    <h1 class="document-type-label"><?php $this->title(); ?></h1>
<?php endif; ?>

<?php do_action('wpo_wcpdf_after_document_label', $this->get_type(), $this->order); ?>

<table class="order-data-addresses">
    <tr>
        <td class="address shipping-address">
            <?php do_action('wpo_wcpdf_before_shipping_address', $this->get_type(), $this->order); ?>
            <p><?php $this->shipping_address(); ?></p>
            <?php do_action('wpo_wcpdf_after_shipping_address', $this->get_type(), $this->order); ?>
            <?php if (isset($this->settings['display_email'])) : ?>
                <div class="billing-email"><?php $this->billing_email(); ?></div>
            <?php endif; ?>
            <?php if (isset($this->settings['display_phone'])) : ?>
                <div class="shipping-phone"><?php $this->shipping_phone(!$this->show_billing_address()); ?></div>
            <?php endif; ?>
        </td>
        <td class="address billing-address">
            <?php if ($this->show_billing_address()) : ?>
                <h3><?php $this->billing_address_title(); ?></h3>
                <?php do_action('wpo_wcpdf_before_billing_address', $this->get_type(), $this->order); ?>
                <p><?php $this->billing_address(); ?></p>
                <?php do_action('wpo_wcpdf_after_billing_address', $this->get_type(), $this->order); ?>
                <?php if (isset($this->settings['display_phone']) && !empty($this->get_billing_phone())) : ?>
                    <div class="billing-phone"><?php $this->billing_phone(); ?></div>
                <?php endif; ?>
            <?php endif; ?>
        </td>
        <td class="order-data">
            <table>
                <?php do_action('wpo_wcpdf_before_order_data', $this->get_type(), $this->order); ?>
                <tr class="order-number">
                    <th><?php $this->order_number_title(); ?></th>
                    <td><?php $this->order_number(); ?></td>
                </tr>
                <tr class="order-date">
                    <th><?php $this->order_date_title(); ?></th>
                    <td><?php $this->order_date(); ?></td>
                </tr>
                <?php if ($this->get_shipping_method()) : ?>
                    <tr class="shipping-method">
                        <th><?php $this->shipping_method_title(); ?></th>
                        <td><?php $this->shipping_method(); ?></td>
                    </tr>
                <?php endif; ?>
                <?php do_action('wpo_wcpdf_after_order_data', $this->get_type(), $this->order); ?>
            </table>
        </td>
    </tr>
</table>

<?php do_action('wpo_wcpdf_before_order_details', $this->get_type(), $this->order); ?>

<table class="order-details">
    <thead>
    <tr>
        <?php foreach (wpo_wcpdf_get_simple_template_default_table_headers($this) as $column_class => $column_title) : ?>
            <th class="<?php echo esc_attr($column_class); ?>"><?php echo esc_html($column_title); ?></th>
        <?php endforeach; ?>
    </tr>
    </thead>
    <tbody>
    <?php
    $index = 0;
    $denumiri_depozit = array(
        '4260680610203' => 'Röllchen aus Hackfleischzubereitung mit Rindfleisch "PUR VITA"',
        '4260680610197' => 'Röllchen aus Hackfleischzubereitung mit Schweine-, Rind- und Schaffleisch "BOIERESTI"',
        '4260680610180' => 'Röllchen aus Hackfleischzubereitung mit Schweine- und Rindfleisch "FORMATI"',
        '4260680610166' => 'Röllchen aus Hackfleischzubereitung mit Schweine- und Rindfleisch "PROMEZ"',
        '4260680610173' => 'Röllchen aus Hackfleischzubereitung mit Schaf- und Rindfleisch "NOBILI/CU OAIE)',
    );
    foreach ($this->get_order_items() as $item_id => $item) :

        $product = $item['product'];
        $qty = $item['quantity'];

        // Detectăm bundle
        $is_bundle = $product && method_exists($product, 'get_bundled_items') && !empty($product->get_bundled_items());

        // Dacă este BUNDLE → afișăm doar produsele din interior, nu și bundle-ul
        if ($is_bundle) {

            $bundled_items = $product->get_bundled_items();

            foreach ($bundled_items as $bundled_item) {

                $bundled_product = $bundled_item->get_product();
                if (!$bundled_product) continue;

                $qty_per_bundle = $bundled_item->get_quantity();
                $qty_total = $qty_per_bundle * $qty;

                // SKU & denumire depozit
                $sku = $bundled_product->get_sku();
                $nume_depozit = $denumiri_depozit[$sku] ?? $bundled_product->get_name();

                $index++;
                ?>
                <tr class="<?php echo esc_html($item['row_class']); ?>">
                    <td class="index"><?php echo $index ?></td>

                    <td class="quantity"><?php echo esc_html($qty_total); ?>.00</td>

                    <td class="cod">
                        <?php if (!empty($sku)) : ?>
                            <p class="sku"><?php echo esc_attr($sku); ?></p>
                        <?php endif; ?>
                    </td>

                    <td class="product">
                        <p class="item-name"><?php echo esc_html($nume_depozit); ?></p>
                    </td>

                    <td class="tva">7.00%</td>
                    <td class="price">-</td>
                    <td class="price">-</td>
                </tr>
                <?php
            }

            continue; // IEȘIM din buclă → bundle-ul nu este afișat niciodată
        }

        // -----------------------------
        // PRODUSE NORMALE (nu bundle)
        // -----------------------------
        $index++;

        $sku = !empty($item['sku']) ? $item['sku'] : '';
        $nume_depozit = $denumiri_depozit[$sku] ?? $item['name'];
        ?>
        <tr class="<?php echo esc_html($item['row_class']); ?>">
            <td class="index"><?php echo $index ?></td>

            <td class="quantity"><?php echo esc_html($item['quantity']); ?>.00</td>

            <td class="cod">
                <?php if (!empty($item['sku'])) : ?>
                    <p class="sku"><?php echo esc_attr($item['sku']); ?></p>
                <?php endif; ?>
            </td>

            <td class="product">
                <p class="item-name"><?php echo esc_html($nume_depozit); ?></p>
            </td>

            <td class="tva">7.00%</td>
            <td class="price">-</td>
            <td class="price">-</td>
        </tr>
    <?php endforeach; ?>
    </tbody>
</table>

<div class="bottom-spacer"></div>

<?php do_action('wpo_wcpdf_after_order_details', $this->get_type(), $this->order); ?>

<?php do_action('wpo_wcpdf_before_customer_notes', $this->get_type(), $this->order); ?>
<?php if ($this->get_shipping_notes()) : ?>
    <div class="customer-notes">
        <h3><?php $this->customer_notes_title() ?></h3>
        <?php $this->shipping_notes(); ?>
    </div>
<?php endif; ?>
<?php do_action('wpo_wcpdf_after_customer_notes', $this->get_type(), $this->order); ?>

<?php if ($this->get_footer()) : ?>
    <htmlpagefooter name="docFooter"><!-- required for mPDF engine -->
        <div id="footer">
            <!-- hook available: wpo_wcpdf_before_footer -->
            <?php $this->footer(); ?>
            <!-- hook available: wpo_wcpdf_after_footer -->
        </div>
    </htmlpagefooter><!-- required for mPDF engine -->
<?php endif; ?>

<?php do_action('wpo_wcpdf_after_document', $this->get_type(), $this->order); ?>

